<?php
/* Trang web Đại Tạng Kinh được lập trình bởi Xuân Duật và đây là mã nguồn mở */

global $pdo; $pdo = new PDO('sqlite:a/db/main.db');

error_reporting(E_ALL); //ini_set('display_errors', 1);
if(!isset($_SESSION)) { session_start();}
date_default_timezone_set('America/Chicago');

function offline(){ return $_SERVER['HTTP_HOST'] == '127.0.0.1:1080' && file_exists('xadmin.php');}
function local(){ return $_SERVER['HTTP_HOST'] == '127.0.0.1:1080';}
function english(){ return $_SESSION['l'] == 'en';}
function lang($en, $viet) { return english() ? $en : $viet;} 
function langsplit($s)
{
	$a = explode(' ﾟ', $s);
	return count($a) == 2 ? lang($a[0], $a[1]) : $s;	
}
function vietlist()
{
	$a = array();
	global $pdo;
	$query = "SELECT * FROM tripitaka_title WHERE Stage='Viet' AND FileID != '--Kinh-Cha-Me-An-Trong-Kho-Bao-Dap' AND FileID != '--Kinh-Nhan-Qua-Ba-Doi' ORDER BY OrderNum ASC";// LIMIT 1
	foreach($pdo->query($query) as $row) array_push($a, $row);
	
	$o;
	$o['TitleID'] = 'T10n0293/40';
	$o['FileID'] = 'Kinh-Dai-Phuong-Quang-Phat-Hoa-Nghiem-40quyen/40';
	$o['Book'] = 1;
	$o['Viet'] = 'Phẩm Vào Cảnh Giới Giải Thoát Chẳng Thể Nghĩ Bàn của Phổ Hiền Hành Nguyện';
	$o['Transliteration1'] = '大Đại 方Phương 廣Quảng 佛Phật 華Hoa 嚴Nghiêm 經Kinh 卷quyển 第đệ 四tứ 十thập';
	$o['Stage'] = 'Viet';
	$o['Divider'] = 1;
	$o['DateTranslated'] = '2012-02-28 00:00:00';
	array_push($a, $o);
	return $a;
}
function hanlist($sql="")
{
	$a = array();
	global $pdo;
	$query = "SELECT * FROM tripitaka_title WHERE Stage='Han' $sql ORDER BY TitleID ASC";// LIMIT 1
	foreach($pdo->query($query) as $row) array_push($a, $row);
	return $a;
}
function isajax(){ return isset($_GET['ajax']);}
function ajax($link, $formname='none', $responsediv = 'content')
{
	if($responsediv == 'popupx')
	{
		return '"' . $link . '" onclick="viewer(\''.$link.'\'); return false;"';
	}
	else
	{
		return '"' . ($responsediv == 'content' || $responsediv == 'popup' ? $link : 'javascript:void(0);') . '" onclick="ajax(\'' . $link . '\',\'' . $formname . '\',\'' . $responsediv . '\'); return false;"';
	}
}
function text_size()
{
	echo '<a href="javascript:void(0);" onclick="fontsizeset(-1);" class=nav><sub>A</sub></a>';
	echo '<a href="javascript:void(0);" onclick="fontsizeset(0);" class=nav>A</a>';
	echo '<a href="javascript:void(0);" onclick="fontsizeset(1);" class=nav><sup>A</sup></a>';
}
function dialectmenu($link = "")
{
	$v = $_SESSION['v'];
	$arr = array('Bắc','Nam');
	$brr = array('bac','nam');
	echo '<sub>Đang dùng phương ngữ:</sub> ';
	for($i = 0; $i < count($arr); $i++)
	{
		echo ($v == $brr[$i] ? '◈':'') . '<a ' . ($v == $brr[$i] ? 'class=navc ':'') . 'href=' . ajax('?' . $link . 'v=' . $brr[$i]) . ' class=nav>' . $arr[$i] . '</a> ';
	}
}
function sutratitle($title, $n, $j)
{
	$sutratitle = $title;
	if($n == 1);
	else if($n == 2)
	{
		if($j == 0) $sutratitle .= " <em>♦ Quyển thượng</em>";
		else $sutratitle = "<em>▫ hạ</em>";
	}
	else if($n == 3)
	{
		if($j == 0) $sutratitle .= " <em>♦ Quyển thượng</em>";
		else if($j == 1) $sutratitle = "<em>▫ trung</em>";
		else $sutratitle = "<em>▫ hạ</em>";
	}
	else
	{
		if($j == 0) $sutratitle .= " <em>♦ Quyển 1</em>";
		else $sutratitle = "<em>▫ ".($j+1)."</em>";
	}
	return $sutratitle;
	
	// ♦ Quyển 1
	/*
	$sutratitle = $title;
	if($n == 1);
	else if($n == 2) $sutratitle .= " ▫ Quyển " . ($j == 0 ? "thượng":"hạ");
	else if($n == 3)
	{
		if($j == 0) $sutratitle .= " ▫ Quyển thượng";
		else if($j == 1) $sutratitle .= " ▫ Quyển trung";
		else $sutratitle .= " ▫ Quyển hạ";
	}
	else $sutratitle = "&nbsp;<sup>↳</sup> Quyển " . ($j+1);
	return $sutratitle;
	*/
}
function dialecthan($s)
{
	if(isset($_SESSION['v']) && $_SESSION['v'] == 'bac') $s = dialecthanbac($s);
	return $s;
}
function dialecthanbac($s)
{
	$vals = arrayBacNam1();
	$s = str_replace(array_keys($vals), $vals, $s);
	return $s;
}
function prettytext($s) { return preg_replace_callback("/\{(.*?)\}/", "prettytextcall", $s); }
function prettytextcall($n)
{
	$a = arraySanskrit();
	$word = $n[1];
	$key = mb_strtolower($n[1], 'UTF-8');
	if(isset($a[$key]))
	{
		$newword = $a[$key];
		
		if(isset($GLOBALS['sanskrits'][$word]))
		{
			return '<span title="'.$newword.'" class=tip>'.$word.'</span>';
		}
		else
		{
			$GLOBALS['sanskrits'][$word] = $newword;
			return $word.' <sup>['.$newword.']</sup>';
		}
	}
	else
	{
		$a = arrayBac2Nam();
		$v = $_SESSION['v'];
		if($v == 'bac' && isset($a[$word]))
		{
			//return '<span class=tip>' . $word . '</span>';
			return $word;
		}
		else if($v == 'nam' && isset($a[$word]))
		{
			//return '<span class=tip>' . $a[$word] . '</span>';
			return $a[$word];
		}
		else if(substr($word, 0, 4) == 'pix|')
		{
			$pix = substr($word, 4);
			$id = preg_replace('/-| |.jpg|\//', '', $pix);
			return lazypix($id, 'a/Images/' . $pix);
		}
		else if(substr($word, 0, 1) == '[' && substr($word, -1, 1) == ']')
		{
			return '<sup>'.$word.'</sup>';
		}
		else return '<em>' . $word . '</em>';
	}
}
function getHan($w)
{
	$pos = strrpos($w, ']');
	$Han = "";
	
	if($pos !== false)
	{
		$Han = substr($w, 0, $pos + 1);
	}
	else
	{
		$Han = mb_substr($w, 0, 1, "UTF-8");
	}
	return $Han;
}
function remove_tag($s)
{
	$s = preg_replace('/\/\*(.*?)\*\//i', '', $s);
	return preg_replace('/\?\?|<|>|~/i', '', $s);
}
function remove_return($s) { return preg_replace('/\\r|\\n/i', '', $s); }
function getHans($s, $mode='all')
{
	//	The following should be escaped if you are trying to match that character
	//	\ ^ . $ | ( ) [ ] * + ? { } ,
	
	// no in this cause error \(|\)
	if($mode == 'all') $s = preg_replace('/、|\?|。|@|\/|\*|\+|-|\[|\]/i', '', remove_tag($s));
	$s = preg_replace('/[a-zA-Z0-9;., ~&;:"\']|，|「|」|”|“|‘|’|!|：|！|？|『|』|《|》|（|）|√|←|→|=|＝|…|\||．|—|；|＊/i', '', $s);

	$s = str_replace(array('#','ā','ḍ','ḥ','ī','ḷ','ḹ','ṁ','ṃ','ṅ','ñ','ṇ','ṇ','ṛ','ṝ','ś','ṣ','ṭ','ū','Đ','Ð','À','Á','Ả','Ã','Ạ','Â','Ầ','Ấ','Ẩ','Ẫ','Ậ','Ă','Ằ','Ắ','Ẳ','Ẵ','Ặ','È','É','Ẻ','Ẽ','Ẹ','Ê','Ề','Ế','Ể','Ễ','Ệ','Ì','Í','Ỉ','Ĩ','Ị','Ò','Ó','Ỏ','Õ','Ọ','Ô','Ồ','Ố','Ổ','Ỗ','Ộ','Ơ','Ờ','Ớ','Ở','Ỡ','Ợ','Ù','Ú','Ủ','Ũ','Ụ','Ư','Ừ','Ứ','Ử','Ữ','Ự','Ỳ','Ý','Ỷ','Ỹ','Ỵ','đ','à','á','ả','ã','ạ','â','ầ','ấ','ẩ','ẫ','ậ','ă','ằ','ắ','ẳ','ẵ','ặ','è','é','ẻ','ẽ','ẹ','ê','ề','ế','ể','ễ','ệ','ì','í','ỉ','ĩ','ị','ò','ó','ỏ','õ','ọ','ô','ồ','ố','ổ','ỗ','ộ','ơ','ờ','ớ','ở','ỡ','ợ','ù','ú','ủ','ũ','ụ','ư','ừ','ứ','ử','ữ','ự','ỳ','ý','ỷ','ỹ','ỵ'), '', $s);
	
	$s = preg_replace('/\n|\r| +|　+/i', '', $s);
	return $s;
}
function getAW($s)
{
	$rval = '';
	$a = explode(' ', remove_tag($s));
	for($i = 0; $i < count($a); $i++)
	{
		$word = $a[$i];
		$han = getHan($word);
		if($han == getHans($han)) $rval .= $han;
		else $rval .= ' ' . $word . ' ';
	}
	return trim($rval);
}
function getHanViet($w)
{
	$pos = strrpos($w, ']');
	$Han = "";
	$Viet = "";
	
	if($pos !== false)
	{
		$Han = substr($w, 0, $pos + 1);
		$Viet = substr($w, $pos + 1);
	}
	else
	{
		$Han = mb_substr($w, 0, 1, "UTF-8");
		$Viet = mb_substr($w, 1, mb_strlen($w), "UTF-8");
	}
	return array($Han, $Viet);
}
function getViets($str)
{
	$s = "";
	$a = explode(" ", $str);
	for($i = 0; $i < count($a); $i++)
	{
		$tmp = getHanViet($a[$i]);
		$s .= $tmp[1] . " ";
	}
	return trim($s);
}
function capitalizeHanViets($s)
{
	$a = explode(" ", $s);
	for($i = 0; $i < count($a); $i++)
	{
		$tmp = getHanViet($a[$i]);
		$chr = mb_substr ($tmp[1], 0, 1, 'UTF-8');
		$a[$i] = $tmp[0] . mb_strtoupper($chr, 'UTF-8') . mb_substr($tmp[1], 1, mb_strlen($tmp[1]), "UTF-8");
	}
	return implode(" ", $a);
}
function writeFile($file, $content)
{
	$fh = fopen($file, 'a'); //append for utf-8
	fwrite($fh, $content);
	fclose($fh);
}
function getcontent($file)
{
	$contents = '';
	$handle = fopen($file, "r");
	$contents = fread($handle, filesize($file));
	fclose($handle);
	return $contents;
}
function getfiles($dir)
{
	$a = array();
	$handle = opendir($dir);
	while(false != ($file = readdir($handle)))
	{
		if(!($file == '.' || $file == '..')) array_push($a, $file);
	}
	closedir($handle);
	array_multisort($a, SORT_ASC);
	return $a;
}
function getmytext($file){ return prettytext(getcontent($file));}
function uniord($u)
{ 
    $k = mb_convert_encoding($u, 'UCS-2LE', 'UTF-8'); 
    $k1 = ord(substr($k, 0, 1)); 
    $k2 = ord(substr($k, 1, 1)); 
    return $k2 * 256 + $k1; 
}
function sutrafile($file)
{
	$s = getcontent($file);
	return sutradata($s);
}
function sutradata($s)
{
	$a = explode("\n", $s);
	if(uniord(substr($a[0], 0, 3)) == 65279) $a[0] = substr($a[0], 3); //special fix
	$arr = array(); $hans = array(); $viets = array(); $isHanzi = true; $length = count($a);
	for($i = 0; $i < $length; $i++)
	{
		$text = remove_return(trim($a[$i]));
		if($isHanzi)
		{
			$isHanzi = false;
			array_push($hans, $text);
		}
		else
		{
			if(	array_key_exists($i+1, $a) && remove_return($a[$i+1]) != "" && $text == "")
			{
				$isHanzi = true;
				array_push($viets, $arr);
				$arr = array();
			}
			else array_push($arr, $text);
		}
	}
	array_push($viets, array($a[$length - 1]));
	return array($hans, $viets);
}
function joinme($a, $start, $end)
{
	$s = "";
	for($i = $start; $i < $end; $i++)
	{
		$s .= $a[$i] . " ";
	}
	return trim($s);
}
function pretty_search($s)
{
	$s = str_replace("'", "’", trim($s));
	$s = preg_replace('/ +/i', " ", $s);
	$vals = arrayBacNam1();
	$s = str_replace(array_keys($vals), $vals, $s);
	$vals = arrayBacNam2();
	$s = str_replace(array_keys($vals), $vals, $s);
	return mb_convert_case(addslashes($s), MB_CASE_TITLE, "UTF-8");
}
function strip_tag($s)
{
	$s = preg_replace('/<(.*?)>/i', "", $s);
	return trim($s);
}
function photoCreateImage($large, $thumb, $maxHeight=180, $quality=90)
{
	$info = getimagesize($large);	
	$maxWidth = 15000;
	if($maxHeight == 1080)
	{
		$maxWidth = 1920;
		$maxHeight = 15000;
	}
	$width = $info[0];
	$height = $info[1];
	
	$o = photoScale($maxWidth, $maxHeight, $width, $height);
	$img = imagecreatetruecolor($o->width, $o->height);
	$image = imagecreatefromjpeg($large);
	imagecopyresampled($img, $image, 0, 0, 0, 0, $o->width, $o->height, $width, $height);
	imagejpeg($img, $thumb, $quality);
	imagedestroy($img);
	imagedestroy($image);
}
function photoScale($maxWidth, $maxHeight, $width, $height)
{
	$obj = new stdClass;
	if($width < $maxWidth){
		$maxWidth = $width;
	}
	if($height < $maxHeight){
		$maxHeight = $height;
	}
	$wRatio = $width / $maxWidth;
	$hRatio = $height / $maxHeight;
	if($wRatio < $hRatio){
		$obj->width = $width * ($maxHeight/ $height);
		$obj->height = $maxHeight;
	} else {
		$obj->width = $maxWidth;
		$obj->height = $height * ($maxWidth / $width);
	}
	return $obj;
}
function format_file_size($file){ return formatfilesize(@filesize($file));}
function formatfilesize($arg)
{
    if ($arg > 0){
        $j = 0;
        $ext = array(" bytes"," Kb"," Mb"," Gb"," Tb");
        while ($arg >= pow(1024,$j)) ++$j;
        return round($arg / pow(1024,$j-1) * 100) / 100 . $ext[$j-1];
    } 
    else return "";
}
function getduration($totalsize)
{
	return time_duration(round($totalsize / (403166059/25197)));
}
function time_duration($seconds, $use = null, $zeros = false)
{
    $periods = array (
        'years'     => 31556926,
        'months'    => 2629743,
        'weeks'     => 604800,
        //'days'      => 86400,
        'hours'     => 3600,
        'minutes'   => 60,
        //'seconds'   => 1
        );
 
    $seconds = (float) $seconds;
    $segments = array();
    foreach ($periods as $period => $value) {
        if ($use && strpos($use, $period[0]) === false) {
            continue;
        }
        $count = floor($seconds / $value);
        if ($count == 0 && !$zeros) {
            continue;
        }
        $segments[strtolower($period)] = $count;
        $seconds = $seconds % $value;
    }
 
    $string = array();
    foreach ($segments as $key => $value) {
        $segment_name = substr($key, 0, -1);
		switch($segment_name)
		{
			case 'year': $segment_name = 'năm'; break;
			case 'month': $segment_name = 'tháng'; break;
			case 'week': $segment_name = 'tuần'; break;
			case 'day': $segment_name = 'ngày'; break;
			case 'hour': $segment_name = 'tiếng'; break;
			case 'minute': $segment_name = 'phút'; break;
			case 'second': $segment_name = 'giây'; break;
		}
        $segment = $value . ' ' . $segment_name;
        //if ($value != 1) $segment .= 's';
        $string[] = $segment;
    }
 
    return implode(', ', $string);
}
class glb
{
    static public function set($name, $value)
    {
        $GLOBALS[$name] = $value;
    }
    static public function get($name)
    {
        return isset($GLOBALS[$name]) ? $GLOBALS[$name] : false;
    }
}
function showdict()
{
	echo '<div id=light class=content>';
	echo '<div id=dict style="padding:5px;"></div>';
	echo '</div><a href="javascript:void(0);" onclick="dictx();return false;"><div id=fade class=overlay></div></a>';
}
function lazypix($id, $src)
{
	return '<div id=lazyload_' . $id . ' style="text-align: center;"><a href="javascript:void(0);" onclick="myLazyload();"><img class="max shadow lazyload" style="cursor: crosshair;" data-src="' . $src . '"></a></div>';
}
function changetitle($title)
{
	echo '<script>document.title = "' . $title . '"</script>';
}
function is_dir_empty($dir)
{
	if (!is_readable($dir)) return NULL; 
	$handle = opendir($dir);
	while (false !== ($entry = readdir($handle)))
	{
		if ($entry != "." && $entry != "..") return FALSE;
	}
	return TRUE;
}
function threedigit($n)
{
	$s = "";
	if($n < 10) $s = "00";
	else if($n < 100) $s = "0";
	return $s . $n;
}
function twodigit($n)
{
	$s = "";
	if($n < 10) $s = "0";
	return $s . $n;
}
function chars_array($text)
{
	$a = array();
	$charadd = "";
	$length = mb_strlen ($text, "UTF-8");
	$left = 0; $right = 0; $initpos = 0;
	for($i = 0; $i < $length; $i++)
	{
		$char = mb_substr($text, $i, 1, "UTF-8");
		$charlen = strlen($char);
		if(!$left && !$right && $charlen >= 3)
		{
			array_push($a, $char);
		}
		else if($char == '[')
		{
			if($left == 0) $initpos = $i;
			$left++;
		}
		else if($char == ']')
		{
			$right++;
		}
		else if(!$left && !$right)
		{
			$charadd .= $char;
			if($i+1 < $length)
			{
				$nextchar =  mb_substr($text, $i+1, 1, "UTF-8");
				if($nextchar == '[' || strlen($nextchar) >= 3)
				{
					array_push($a, $charadd);
					$charadd = "";
				}
			}
			else
			{
				array_push($a, $charadd);
				$charadd = "";
			}
		}

		if($left && $left == $right)
		{
			$charall = mb_substr($text, $initpos, $i - $initpos + 1, "UTF-8");
			array_push($a, $charall);
			$left = 0; $right = 0; $initpos = 0;
		}
	}
	return $a;
}
function multiplePronuciation($word)
{
	if(!offline()) return $word;//admin
	
	$hviets = ['甕','屏','乾','梵','差','累','參','慊','傅','隕','綮','摽','釘','監','傳','否','閒','緣','縣','禁','創','厭','挑','朝','束','沮','疏','著','調','醯','蹙','座','爭','王','冠','食','撰','屬','勝','彊','扇','嗟','倉','咽','斷','衍','鮮','惡','載','辟','悔','兩','揵','卒','稱','易','為','校','般','背','橫','號','覆','中','命','使','更','陰','縱','強','量','行','降','數','施','盛','唯','供','少','令','藏','將','夫','種','處','好','進','間','養','葉','觀','比','土','樂','住','難','宿','重','語','分','不','長','若','應','相','無'];
	$han = getHanViet($word)[0];
	if(in_array($han, $hviets)) return '<span class=tip>' . $word . '</span>';
	else return $word;
}
function arrayIndex()
{
	$a = array('0'=>'0','á'=>'1','a'=>'2','ả'=>'3','ác'=>'4','ách'=>'5','ai'=>'6','ái'=>'7','ải'=>'8','ấm'=>'9','âm'=>'10','am'=>'11','ám'=>'12','ẩm'=>'13','ảm'=>'14','ấn'=>'15','án'=>'16','an'=>'17','ân'=>'18','ẩn'=>'19','áng'=>'20','anh'=>'21','ảnh'=>'22','ánh'=>'23','áo'=>'24','ao'=>'25','ảo'=>'26','áp'=>'27','ấp'=>'28','át'=>'29','ất'=>'30','ấu'=>'31','âu'=>'32','ẩu'=>'33','bá'=>'34','bà'=>'35','ba'=>'36','bả'=>'37','bạ'=>'38','bác'=>'39','bắc'=>'40','bạc'=>'41','bặc'=>'42','bạch'=>'43','bách'=>'44','bái'=>'45','bài'=>'46','bãi'=>'47','bại'=>'48','bẩm'=>'49','bạn'=>'50','bán'=>'51','bấn'=>'52','ban'=>'53','bản'=>'54','bàn'=>'55','bần'=>'56','bân'=>'57','bận'=>'58','bẫn'=>'59','bàng'=>'60','băng'=>'61','bang'=>'62','bằng'=>'63','báng'=>'64','bạng'=>'65','bảng'=>'66','bẵng'=>'67','bành'=>'68','banh'=>'69','bảo'=>'70','bao'=>'71','báo'=>'72','bào'=>'73','bão'=>'74','bạo'=>'75','bất'=>'76','bát'=>'77','bạt'=>'78','bật'=>'79','bầu'=>'80','bẫu'=>'81','bậu'=>'82','bệ'=>'83','bế'=>'84','bễ'=>'85','bề'=>'86','bệnh'=>'87','bị'=>'88','bĩ'=>'89','bỉ'=>'90','bi'=>'91','bí'=>'92','bì'=>'93','bia'=>'94','bích'=>'95','bịch'=>'96','biếm'=>'97','biêm'=>'98','biển'=>'99','biến'=>'100','biện'=>'101','biên'=>'102','biền'=>'103','biệt'=>'104','biết'=>'105','biều'=>'106','biểu'=>'107','biễu'=>'108','binh'=>'109','bình'=>'110','bính'=>'111','bỉnh'=>'112','bộ'=>'113','bố'=>'114','bồ'=>'115','bổ'=>'116','bô'=>'117','bộc'=>'118','bốc'=>'119','bội'=>'120','bối'=>'121','bồi'=>'122','bôi'=>'123','bộn'=>'124','bôn'=>'125','bổn'=>'126','bồn'=>'127','bổng'=>'128','bồng'=>'129','bông'=>'130','bột'=>'131','bức'=>'132','bùi'=>'133','bút'=>'134','bưu'=>'135','ca'=>'136','cả'=>'137','cá'=>'138','cà'=>'139','các'=>'140','cách'=>'141','cái'=>'142','cai'=>'143','cải'=>'144','cảm'=>'145','cầm'=>'146','cam'=>'147','cấm'=>'148','cám'=>'149','cẩm'=>'150','câm'=>'151','cãm'=>'152','can'=>'153','càn'=>'154','cần'=>'155','cân'=>'156','căn'=>'157','cán'=>'158','cận'=>'159','cẩn'=>'160','cấn'=>'161','cản'=>'162','cang'=>'163','cáng'=>'164','căng'=>'165','cắng'=>'166','cảng'=>'167','cảnh'=>'168','cánh'=>'169','canh'=>'170','cạnh'=>'171','cáo'=>'172','cảo'=>'173','cao'=>'174','cập'=>'175','cấp'=>'176','cáp'=>'177','cát'=>'178','cật'=>'179','câu'=>'180','cấu'=>'181','cầu'=>'182','cẩu'=>'183','chá'=>'184','cha'=>'185','chà'=>'186','châm'=>'187','chẩm'=>'188','chậm'=>'189','chấm'=>'190','chấn'=>'191','chân'=>'192','chẩn'=>'193','chăn'=>'194','chàng'=>'195','chang'=>'196','chánh'=>'197','chấp'=>'198','chập'=>'199','chất'=>'200','châu'=>'201','chế'=>'202','chênh'=>'203','chi'=>'204','chỉ'=>'205','chí'=>'206','chích'=>'207','chiêm'=>'208','chiếm'=>'209','chiến'=>'210','chiên'=>'211','chiển'=>'212','chiếp'=>'213','chiệp'=>'214','chiết'=>'215','chiêu'=>'216','chiểu'=>'217','chiếu'=>'218','chinh'=>'219','chính'=>'220','chỉnh'=>'221','chơn'=>'222','chủ'=>'223','chu'=>'224','chú'=>'225','chử'=>'226','chư'=>'227','chù'=>'228','chứ'=>'229','chuẩn'=>'230','chuân'=>'231','chúc'=>'232','chức'=>'233','chuế'=>'234','chung'=>'235','chửng'=>'236','chúng'=>'237','chủng'=>'238','chứng'=>'239','chưng'=>'240','chước'=>'241','chương'=>'242','chưởng'=>'243','chướng'=>'244','chựu'=>'245','chửu'=>'246','chúy'=>'247','chùy'=>'248','chủy'=>'249','chuy'=>'250','chuyên'=>'251','chuyển'=>'252','chuyến'=>'253','chuyết'=>'254','cổ'=>'255','cố'=>'256','cơ'=>'257','cô'=>'258','cốc'=>'259','côi'=>'260','cối'=>'261','cổn'=>'262','côn'=>'263','công'=>'264','cộng'=>'265','cống'=>'266','cốt'=>'267','cột'=>'268','cu'=>'269','cụ'=>'270','cù'=>'271','cú'=>'272','cư'=>'273','cự'=>'274','cứ'=>'275','cừ'=>'276','củ'=>'277','cử'=>'278','cũ'=>'279','cục'=>'280','cúc'=>'281','cức'=>'282','cực'=>'283','cung'=>'284','cúng'=>'285','củng'=>'286','cùng'=>'287','cước'=>'288','cược'=>'289','cương'=>'290','cường'=>'291','cưỡng'=>'292','cuồng'=>'293','cuống'=>'294','cửu'=>'295','cừu'=>'296','cữu'=>'297','cứu'=>'298','cựu'=>'299','cưu'=>'300','dã'=>'301','dạ'=>'302','da'=>'303','dặc'=>'304','dác'=>'305','dâm'=>'306','dam'=>'307','dảm'=>'308','dần'=>'309','dẫn'=>'310','dân'=>'311','dận'=>'312','dấn'=>'313','dạng'=>'314','dăng'=>'315','dắng'=>'316','danh'=>'317','dao'=>'318','dập'=>'319','dật'=>'320','dậu'=>'321','dẫu'=>'322','dĩ'=>'323','di'=>'324','dị'=>'325','dịch'=>'326','diệc'=>'327','diêm'=>'328','diễm'=>'329','diệm'=>'330','diên'=>'331','diễn'=>'332','diện'=>'333','diến'=>'334','diệp'=>'335','diếp'=>'336','diệt'=>'337','diệu'=>'338','diêu'=>'339','diểu'=>'340','diếu'=>'341','dĩnh'=>'342','dinh'=>'343','do'=>'344','doãn'=>'345','doanh'=>'346','dong'=>'347','dữ'=>'348','dụ'=>'349','du'=>'350','dũ'=>'351','dự'=>'352','dư'=>'353','duẩn'=>'354','duẫn'=>'355','duật'=>'356','dục'=>'357','dực'=>'358','duệ'=>'359','dũng'=>'360','dựng'=>'361','dung'=>'362','dụng'=>'363','dược'=>'364','dương'=>'365','dưỡng'=>'366','dường'=>'367','dượng'=>'368','dữu'=>'369','dứu'=>'370','dựu'=>'371','dửu'=>'372','dụy'=>'373','duy'=>'374','duyên'=>'375','duyện'=>'376','duyệt'=>'377','đà'=>'378','đa'=>'379','đả'=>'380','đạ'=>'381','đá'=>'382','đắc'=>'383','đặc'=>'384','đạc'=>'385','đại'=>'386','đài'=>'387','đái'=>'388','đãi'=>'389','đạm'=>'390','đàm'=>'391','đảm'=>'392','đam'=>'393','đãm'=>'394','đan'=>'395','đãn'=>'396','đàn'=>'397','đạn'=>'398','đán'=>'399','đản'=>'400','đẳng'=>'401','đăng'=>'402','đang'=>'403','đãng'=>'404','đằng'=>'405','đảng'=>'406','đắng'=>'407','đặng'=>'408','đáng'=>'409','đảnh'=>'410','đảo'=>'411','đao'=>'412','đáo'=>'413','đạo'=>'414','đào'=>'415','đạp'=>'416','đáp'=>'417','đát'=>'418','đạt'=>'419','đâu'=>'420','đầu'=>'421','đẩu'=>'422','đậu'=>'423','đấu'=>'424','đau'=>'425','đê'=>'426','đề'=>'427','để'=>'428','đế'=>'429','đệ'=>'430','đễ'=>'431','địa'=>'432','đích'=>'433','địch'=>'434','điềm'=>'435','điếm'=>'436','điểm'=>'437','điêm'=>'438','điệm'=>'439','điển'=>'440','điền'=>'441','điễn'=>'442','điện'=>'443','điên'=>'444','điến'=>'445','điệp'=>'446','điếp'=>'447','điệt'=>'448','điêu'=>'449','điếu'=>'450','điều'=>'451','điệu'=>'452','điểu'=>'453','đinh'=>'454','đình'=>'455','định'=>'456','đĩnh'=>'457','đỉnh'=>'458','đính'=>'459','độ'=>'460','đổ'=>'461','đồ'=>'462','đố'=>'463','đỗ'=>'464','đô'=>'465','đóa'=>'466','đỏa'=>'467','đọa'=>'468','đoái'=>'469','đoài'=>'470','đoàn'=>'471','đoán'=>'472','đoạn'=>'473','đoản'=>'474','đoan'=>'475','đoạt'=>'476','độc'=>'477','đốc'=>'478','đọc'=>'479','đôi'=>'480','đối'=>'481','đỗi'=>'482','đội'=>'483','đồi'=>'484','đởm'=>'485','đơn'=>'486','đôn'=>'487','độn'=>'488','đốn'=>'489','đồn'=>'490','đồng'=>'491','đông'=>'492','đống'=>'493','động'=>'494','đỗng'=>'495','đổng'=>'496','đốt'=>'497','đột'=>'498','đức'=>'499','đường'=>'500','đương'=>'501','ế'=>'502','ê'=>'503','già'=>'504','giả'=>'505','giá'=>'506','gia'=>'507','giạ'=>'508','giác'=>'509','giai'=>'510','giải'=>'511','giái'=>'512','giảm'=>'513','giám'=>'514','giam'=>'515','gian'=>'516','giản'=>'517','gián'=>'518','giang'=>'519','giảng'=>'520','giáng'=>'521','giao'=>'522','giảo'=>'523','giáo'=>'524','giáp'=>'525','giếu'=>'526','giốc'=>'527','giới'=>'528','hạ'=>'529','hà'=>'530','ha'=>'531','há'=>'532','hác'=>'533','hạc'=>'534','hắc'=>'535','hặc'=>'536','hách'=>'537','hạch'=>'538','hài'=>'539','hại'=>'540','hải'=>'541','hãi'=>'542','hai'=>'543','hàm'=>'544','hám'=>'545','hạm'=>'546','hãm'=>'547','hâm'=>'548','ham'=>'549','hảm'=>'550','hàn'=>'551','hãn'=>'552','hận'=>'553','hạn'=>'554','hân'=>'555','hán'=>'556','hấn'=>'557','han'=>'558','hạng'=>'559','hằng'=>'560','hàng'=>'561','hang'=>'562','hãng'=>'563','hãnh'=>'564','hạnh'=>'565','hành'=>'566','hanh'=>'567','hao'=>'568','hào'=>'569','háo'=>'570','hảo'=>'571','hạo'=>'572','hấp'=>'573','hạp'=>'574','hát'=>'575','hắt'=>'576','hạt'=>'577','hất'=>'578','hật'=>'579','hầu'=>'580','hậu'=>'581','hấu'=>'582','hệ'=>'583','hề'=>'584','hê'=>'585','hễ'=>'586','hi'=>'587','hí'=>'588','hĩ'=>'589','hỉ'=>'590','hích'=>'591','hịch'=>'592','hiềm'=>'593','hiểm'=>'594','hiêm'=>'595','hiển'=>'596','hiến'=>'597','hiện'=>'598','hiền'=>'599','hiên'=>'600','hiệp'=>'601','hiếp'=>'602','hiết'=>'603','hiệt'=>'604','hiệu'=>'605','hiếu'=>'606','hiểu'=>'607','hiêu'=>'608','hình'=>'609','hinh'=>'610','hĩnh'=>'611','hồ'=>'612','hỗ'=>'613','hô'=>'614','hộ'=>'615','hổ'=>'616','hố'=>'617','hóa'=>'618','hòa'=>'619','hỏa'=>'620','họa'=>'621','hoa'=>'622','hõa'=>'623','hoặc'=>'624','hoắc'=>'625','hoạch'=>'626','hoại'=>'627','hoài'=>'628','hoàn'=>'629','hoán'=>'630','hoạn'=>'631','hoan'=>'632','hoãn'=>'633','hoản'=>'634','hoằng'=>'635','hoàng'=>'636','hoảng'=>'637','hoang'=>'638','hoăng'=>'639','hoạnh'=>'640','hoành'=>'641','hoanh'=>'642','hoạt'=>'643','hoát'=>'644','học'=>'645','hộc'=>'646','hốc'=>'647','hòe'=>'648','hồi'=>'649','hối'=>'650','hội'=>'651','hôi'=>'652','hợi'=>'653','hổi'=>'654','hôn'=>'655','hỗn'=>'656','hồn'=>'657','hồng'=>'658','hống'=>'659','hợp'=>'660','hốt'=>'661','hột'=>'662','hu'=>'663','hư'=>'664','hủ'=>'665','hử'=>'666','hú'=>'667','hứa'=>'668','huân'=>'669','huấn'=>'670','huất'=>'671','húc'=>'672','hức'=>'673','hực'=>'674','huệ'=>'675','huề'=>'676','hung'=>'677','hùng'=>'678','hưng'=>'679','húng'=>'680','hứng'=>'681','hước'=>'682','hưởng'=>'683','hướng'=>'684','huống'=>'685','hương'=>'686','hưu'=>'687','hữu'=>'688','hựu'=>'689','hủy'=>'690','huy'=>'691','húy'=>'692','huých'=>'693','huyễn'=>'694','huyền'=>'695','huyện'=>'696','huyên'=>'697','huyến'=>'698','huyệt'=>'699','huyết'=>'700','huynh'=>'701','huỳnh'=>'702','huýnh'=>'703','hỷ'=>'704','hy'=>'705','ích'=>'706','kệ'=>'707','kế'=>'708','kê'=>'709','kềnh'=>'710','kết'=>'711','khả'=>'712','kha'=>'713','khắc'=>'714','khác'=>'715','khạc'=>'716','khách'=>'717','khái'=>'718','khải'=>'719','khai'=>'720','khảm'=>'721','kham'=>'722','khâm'=>'723','khám'=>'724','khấm'=>'725','khẩn'=>'726','khán'=>'727','khản'=>'728','khan'=>'729','kháng'=>'730','khang'=>'731','khẳng'=>'732','khảng'=>'733','khanh'=>'734','khánh'=>'735','khao'=>'736','khảo'=>'737','khào'=>'738','kháo'=>'739','kháp'=>'740','khấp'=>'741','khạp'=>'742','khất'=>'743','khát'=>'744','khâu'=>'745','khẩu'=>'746','khấu'=>'747','khế'=>'748','khê'=>'749','khể'=>'750','kheo'=>'751','khí'=>'752','khi'=>'753','khỉ'=>'754','khích'=>'755','khiếm'=>'756','khiêm'=>'757','khiểm'=>'758','khiệm'=>'759','khiên'=>'760','khiển'=>'761','khiếp'=>'762','khiết'=>'763','khiếu'=>'764','khiêu'=>'765','khinh'=>'766','khính'=>'767','khô'=>'768','khố'=>'769','khổ'=>'770','khóa'=>'771','khỏa'=>'772','khoa'=>'773','khòa'=>'774','khoắc'=>'775','khoác'=>'776','khoách'=>'777','khoái'=>'778','khoán'=>'779','khoan'=>'780','khoản'=>'781','khoáng'=>'782','khoảnh'=>'783','khoát'=>'784','khốc'=>'785','khối'=>'786','khôi'=>'787','khởi'=>'788','khốn'=>'789','khổn'=>'790','khôn'=>'791','khổng'=>'792','không'=>'793','khống'=>'794','khốt'=>'795','khư'=>'796','khứ'=>'797','khu'=>'798','khủ'=>'799','khuân'=>'800','khuẩn'=>'801','khuất'=>'802','khúc'=>'803','khuể'=>'804','khuê'=>'805','khuế'=>'806','khuếch'=>'807','khủng'=>'808','khung'=>'809','khúng'=>'810','khước'=>'811','khương'=>'812','khuông'=>'813','khứu'=>'814','khưu'=>'815','khuy'=>'816','khụy'=>'817','khuých'=>'818','khuyến'=>'819','khuyển'=>'820','khuyên'=>'821','khuyết'=>'822','khuynh'=>'823','kì'=>'824','ki'=>'825','kí'=>'826','kị'=>'827','kỉ'=>'828','kĩ'=>'829','kịch'=>'830','kích'=>'831','kiệm'=>'832','kiêm'=>'833','kiếm'=>'834','kiểm'=>'835','kiềm'=>'836','kiền'=>'837','kiện'=>'838','kiên'=>'839','kiến'=>'840','kiển'=>'841','kiếp'=>'842','kiệp'=>'843','kiết'=>'844','kiệt'=>'845','kiểu'=>'846','kiều'=>'847','kiêu'=>'848','kiệu'=>'849','kiếu'=>'850','kim'=>'851','kinh'=>'852','kính'=>'853','kình'=>'854','kịp'=>'855','kỹ'=>'856','kỳ'=>'857','ký'=>'858','kỷ'=>'859','kỵ'=>'860','ky'=>'861','la'=>'862','lã'=>'863','lặc'=>'864','lạc'=>'865','lai'=>'866','lại'=>'867','lãi'=>'868','lam'=>'869','lãm'=>'870','lẫm'=>'871','lâm'=>'872','lạm'=>'873','lấm'=>'874','lận'=>'875','lan'=>'876','lãn'=>'877','lân'=>'878','lạn'=>'879','lấn'=>'880','lăng'=>'881','lãng'=>'882','lang'=>'883','lạng'=>'884','lắng'=>'885','lãnh'=>'886','lánh'=>'887','lao'=>'888','lão'=>'889','lạo'=>'890','lạp'=>'891','lập'=>'892','lạt'=>'893','lật'=>'894','lặt'=>'895','lâu'=>'896','lầu'=>'897','lậu'=>'898','lệ'=>'899','lê'=>'900','lễ'=>'901','lệnh'=>'902','li'=>'903','lị'=>'904','lí'=>'905','lịch'=>'906','liểm'=>'907','liệm'=>'908','liễm'=>'909','liêm'=>'910','liên'=>'911','liễn'=>'912','liệp'=>'913','liệt'=>'914','liễu'=>'915','liệu'=>'916','liêu'=>'917','liểu'=>'918','linh'=>'919','lĩnh'=>'920','lịnh'=>'921','lô'=>'922','lỗ'=>'923','lộ'=>'924','lõa'=>'925','lỏa'=>'926','loa'=>'927','loại'=>'928','loạn'=>'929','loan'=>'930','loát'=>'931','lộc'=>'932','lợi'=>'933','lôi'=>'934','lỗi'=>'935','lôn'=>'936','lộng'=>'937','long'=>'938','lông'=>'939','lữ'=>'940','lũ'=>'941','lư'=>'942','lự'=>'943','lụ'=>'944','lu'=>'945','luân'=>'946','luận'=>'947','luật'=>'948','lục'=>'949','lực'=>'950','lung'=>'951','lũng'=>'952','lược'=>'953','lượng'=>'954','lưỡng'=>'955','lương'=>'956','lưu'=>'957','lựu'=>'958','lữu'=>'959','lũy'=>'960','lụy'=>'961','luy'=>'962','luyến'=>'963','luyện'=>'964','luyên'=>'965','luyệt'=>'966','lý'=>'967','ly'=>'968','lỵ'=>'969','ma'=>'970','mã'=>'971','mạ'=>'972','má'=>'973','mặc'=>'974','mạc'=>'975','mạch'=>'976','mai'=>'977','mãi'=>'978','mại'=>'979','măm'=>'980','mâm'=>'981','màn'=>'982','mẫn'=>'983','mạn'=>'984','mãn'=>'985','man'=>'986','mấn'=>'987','mân'=>'988','mán'=>'989','mạng'=>'990','mang'=>'991','măng'=>'992','mãng'=>'993','mặng'=>'994','mãnh'=>'995','manh'=>'996','mạnh'=>'997','mạo'=>'998','mao'=>'999','mão'=>'1000','máo'=>'1001','mật'=>'1002','mạt'=>'1003','mẫu'=>'1004','mâu'=>'1005','mậu'=>'1006','mế'=>'1007','mễ'=>'1008','mê'=>'1009','mệ'=>'1010','mên'=>'1011','mệnh'=>'1012','mẹo'=>'1013','mị'=>'1014','mi'=>'1015','mĩ'=>'1016','mịch'=>'1017','miễn'=>'1018','miện'=>'1019','miên'=>'1020','miến'=>'1021','miệt'=>'1022','miết'=>'1023','miếu'=>'1024','miễu'=>'1025','miêu'=>'1026','miệu'=>'1027','miểu'=>'1028','minh'=>'1029','mính'=>'1030','mộ'=>'1031','mỗ'=>'1032','mô'=>'1033','mộc'=>'1034','mỗi'=>'1035','môi'=>'1036','mội'=>'1037','môn'=>'1038','mộng'=>'1039','mông'=>'1040','một'=>'1041','mụ'=>'1042','mu'=>'1043','mục'=>'1044','mùi'=>'1045','muội'=>'1046','muộn'=>'1047','mưu'=>'1048','mỹ'=>'1049','my'=>'1050','na'=>'1051','nã'=>'1052','nả'=>'1053','nà'=>'1054','nặc'=>'1055','nạch'=>'1056','nãi'=>'1057','nại'=>'1058','nai'=>'1059','nam'=>'1060','nẩm'=>'1061','nẫm'=>'1062','﻿nam'=>'1063','nạm'=>'1064','nâm'=>'1065','nảm'=>'1066','nạn'=>'1067','nan'=>'1068','nãn'=>'1069','nang'=>'1070','nẵng'=>'1071','năng'=>'1072','﻿nẵng'=>'1073','nãng'=>'1074','nảnh'=>'1075','nanh'=>'1076','não'=>'1077','nạo'=>'1078','nao'=>'1079','náo'=>'1080','nạp'=>'1081','nật'=>'1082','nát'=>'1083','nậu'=>'1084','nễ'=>'1085','nê'=>'1086','nể'=>'1087','nệ'=>'1088','ngã'=>'1089','nga'=>'1090','ngạ'=>'1091','ngạc'=>'1092','ngạch'=>'1093','ngải'=>'1094','ngại'=>'1095','ngãi'=>'1096','ngái'=>'1097','ngai'=>'1098','ngâm'=>'1099','ngân'=>'1100','ngạn'=>'1101','ngận'=>'1102','ngan'=>'1103','ngang'=>'1104','ngạnh'=>'1105','ngạo'=>'1106','ngao'=>'1107','ngập'=>'1108','ngật'=>'1109','ngạt'=>'1110','ngẫu'=>'1111','ngầu'=>'1112','nghê'=>'1113','nghệ'=>'1114','nghễ'=>'1115','nghênh'=>'1116','nghi'=>'1117','nghĩ'=>'1118','nghị'=>'1119','nghĩa'=>'1120','nghịch'=>'1121','nghiễm'=>'1122','nghiêm'=>'1123','nghiệm'=>'1124','nghiên'=>'1125','nghiễn'=>'1126','nghiện'=>'1127','nghiệp'=>'1128','nghiệt'=>'1129','nghiêu'=>'1130','nghịnh'=>'1131','ngọ'=>'1132','ngô'=>'1133','ngỗ'=>'1134','ngộ'=>'1135','ngõa'=>'1136','ngọa'=>'1137','ngoa'=>'1138','ngỏa'=>'1139','ngóa'=>'1140','ngoại'=>'1141','ngoạn'=>'1142','ngoan'=>'1143','ngoạt'=>'1144','ngọc'=>'1145','ngốc'=>'1146','ngôi'=>'1147','ngôn'=>'1148','ngộn'=>'1149','ngột'=>'1150','ngũ'=>'1151','ngữ'=>'1152','ngu'=>'1153','ngụ'=>'1154','ngự'=>'1155','ngư'=>'1156','ngứ'=>'1157','ngục'=>'1158','ngực'=>'1159','ngưng'=>'1160','ngung'=>'1161','ngược'=>'1162','ngưỡng'=>'1163','ngưu'=>'1164','ngụy'=>'1165','nguy'=>'1166','nguyên'=>'1167','nguyện'=>'1168','nguyễn'=>'1169','nguyệt'=>'1170','nhạ'=>'1171','nha'=>'1172','nhã'=>'1173','nhạc'=>'1174','nhai'=>'1175','nhậm'=>'1176','nhâm'=>'1177','nham'=>'1178','nhẫm'=>'1179','nhân'=>'1180','nhận'=>'1181','nhẫn'=>'1182','nhãn'=>'1183','nhàn'=>'1184','nhạn'=>'1185','nhan'=>'1186','nhạng'=>'1187','nhạo'=>'1188','nháo'=>'1189','nhập'=>'1190','nhất'=>'1191','nhật'=>'1192','nhị'=>'1193','nhi'=>'1194','nhĩ'=>'1195','nhiễm'=>'1196','nhiêm'=>'1197','nhiệm'=>'1198','nhiên'=>'1199','nhiễn'=>'1200','nhiếp'=>'1201','nhiệt'=>'1202','nhiễu'=>'1203','nhiêu'=>'1204','nho'=>'1205','nhũ'=>'1206','như'=>'1207','nhu'=>'1208','nhữ'=>'1209','nhụ'=>'1210','nhứ'=>'1211','nhự'=>'1212','nhuận'=>'1213','nhục'=>'1214','nhuế'=>'1215','nhuệ'=>'1216','nhưng'=>'1217','nhung'=>'1218','nhũng'=>'1219','nhược'=>'1220','nhưỡng'=>'1221','nhương'=>'1222','nhượng'=>'1223','nhựt'=>'1224','nhữu'=>'1225','nhựu'=>'1226','nhuy'=>'1227','nhuyễn'=>'1228','nhuyên'=>'1229','nhuyến'=>'1230','ni'=>'1231','nị'=>'1232','nỉ'=>'1233','nịch'=>'1234','niệm'=>'1235','niêm'=>'1236','niên'=>'1237','niễn'=>'1238','niện'=>'1239','niếp'=>'1240','niệp'=>'1241','niết'=>'1242','niệt'=>'1243','niệu'=>'1244','niểu'=>'1245','niễu'=>'1246','nịnh'=>'1247','ninh'=>'1248','nính'=>'1249','nỗ'=>'1250','nô'=>'1251','nộ'=>'1252','noa'=>'1253','nọa'=>'1254','nỏa'=>'1255','noãn'=>'1256','noản'=>'1257','nội'=>'1258','nỗi'=>'1259','nộn'=>'1260','nông'=>'1261','nồng'=>'1262','nột'=>'1263','nữ'=>'1264','nư'=>'1265','nứ'=>'1266','nục'=>'1267','nùng'=>'1268','nương'=>'1269','nữu'=>'1270','nuy'=>'1271','nụy'=>'1272','ny'=>'1273','ô'=>'1274','ổ'=>'1275','o'=>'1276','ố'=>'1277','oa'=>'1278','oách'=>'1279','oai'=>'1280','oái'=>'1281','oan'=>'1282','oán'=>'1283','oản'=>'1284','oánh'=>'1285','oanh'=>'1286','oạt'=>'1287','oát'=>'1288','ốc'=>'1289','ổi'=>'1290','ôi'=>'1291','ới'=>'1292','ôn'=>'1293','ổn'=>'1294','ông'=>'1295','ống'=>'1296','ổng'=>'1297','ốt'=>'1298','ột'=>'1299','phả'=>'1300','phạ'=>'1301','pha'=>'1302','phá'=>'1303','phác'=>'1304','phách'=>'1305','phái'=>'1306','phàm'=>'1307','phẩm'=>'1308','phạm'=>'1309','phâm'=>'1310','phần'=>'1311','phân'=>'1312','phán'=>'1313','phản'=>'1314','phấn'=>'1315','phan'=>'1316','phẫn'=>'1317','phàn'=>'1318','phẩn'=>'1319','phạn'=>'1320','phận'=>'1321','phãn'=>'1322','phảng'=>'1323','phang'=>'1324','phanh'=>'1325','phao'=>'1326','pháo'=>'1327','phạp'=>'1328','pháp'=>'1329','phạt'=>'1330','phất'=>'1331','phát'=>'1332','phật'=>'1333','phẫu'=>'1334','phầu'=>'1335','phẩu'=>'1336','phấu'=>'1337','phệ'=>'1338','phế'=>'1339','phê'=>'1340','phi'=>'1341','phí'=>'1342','phỉ'=>'1343','phì'=>'1344','phích'=>'1345','phiếm'=>'1346','phiến'=>'1347','phiền'=>'1348','phiên'=>'1349','phiệt'=>'1350','phiết'=>'1351','phiêu'=>'1352','phiếu'=>'1353','phiểu'=>'1354','phinh'=>'1355','phó'=>'1356','phổ'=>'1357','phô'=>'1358','phố'=>'1359','phò'=>'1360','pho'=>'1361','phộc'=>'1362','phốc'=>'1363','phọc'=>'1364','phối'=>'1365','phôi'=>'1366','phồn'=>'1367','phôn'=>'1368','phong'=>'1369','phòng'=>'1370','phóng'=>'1371','phỏng'=>'1372','phủ'=>'1373','phụ'=>'1374','phù'=>'1375','phu'=>'1376','phú'=>'1377','phũ'=>'1378','phục'=>'1379','phúc'=>'1380','phức'=>'1381','phún'=>'1382','phun'=>'1383','phụng'=>'1384','phủng'=>'1385','phùng'=>'1386','phúng'=>'1387','phước'=>'1388','phược'=>'1389','phường'=>'1390','phương'=>'1391','phưởng'=>'1392','phượng'=>'1393','phướng'=>'1394','phữu'=>'1395','quả'=>'1396','qua'=>'1397','quá'=>'1398','quặc'=>'1399','quắc'=>'1400','quách'=>'1401','quai'=>'1402','quái'=>'1403','quải'=>'1404','quan'=>'1405','quán'=>'1406','quân'=>'1407','quản'=>'1408','quần'=>'1409','quận'=>'1410','quẫn'=>'1411','quấn'=>'1412','quang'=>'1413','quảng'=>'1414','quáng'=>'1415','quăng'=>'1416','quánh'=>'1417','quật'=>'1418','quất'=>'1419','quát'=>'1420','quạt'=>'1421','quế'=>'1422','quệ'=>'1423','quốc'=>'1424','quỹ'=>'1425','quý'=>'1426','quy'=>'1427','quỵ'=>'1428','quỷ'=>'1429','quỳ'=>'1430','quých'=>'1431','quyện'=>'1432','quyển'=>'1433','quyền'=>'1434','quyên'=>'1435','quyến'=>'1436','quyết'=>'1437','quyệt'=>'1438','quỳnh'=>'1439','quynh'=>'1440','quýnh'=>'1441','ra'=>'1442','rị'=>'1443','rô'=>'1444','sạ'=>'1445','sá'=>'1446','sa'=>'1447','sắc'=>'1448','sác'=>'1449','sách'=>'1450','sài'=>'1451','sai'=>'1452','sái'=>'1453','sâm'=>'1454','sầm'=>'1455','sám'=>'1456','sam'=>'1457','sàm'=>'1458','sấm'=>'1459','sảm'=>'1460','san'=>'1461','sản'=>'1462','sân'=>'1463','sằn'=>'1464','sấn'=>'1465','sàn'=>'1466','sạn'=>'1467','sán'=>'1468','sẩn'=>'1469','sáng'=>'1470','sàng'=>'1471','sảng'=>'1472','sang'=>'1473','sanh'=>'1474','sảnh'=>'1475','sào'=>'1476','sao'=>'1477','sảo'=>'1478','sáo'=>'1479','sáp'=>'1480','sạp'=>'1481','sát'=>'1482','sất'=>'1483','sắt'=>'1484','sầu'=>'1485','sấu'=>'1486','sậu'=>'1487','sế'=>'1488','sĩ'=>'1489','sỉ'=>'1490','sí'=>'1491','si'=>'1492','siểm'=>'1493','siêm'=>'1494','siển'=>'1495','siếp'=>'1496','siêu'=>'1497','siếu'=>'1498','sính'=>'1499','sinh'=>'1500','sơ'=>'1501','sở'=>'1502','sổ'=>'1503','số'=>'1504','sớ'=>'1505','sô'=>'1506','sồ'=>'1507','sọa'=>'1508','soa'=>'1509','soạn'=>'1510','soán'=>'1511','soan'=>'1512','soát'=>'1513','sóc'=>'1514','sơn'=>'1515','sôn'=>'1516','song'=>'1517','sự'=>'1518','sứ'=>'1519','sử'=>'1520','sư'=>'1521','sừ'=>'1522','suân'=>'1523','suất'=>'1524','súc'=>'1525','sức'=>'1526','sung'=>'1527','sủng'=>'1528','sùng'=>'1529','súng'=>'1530','sước'=>'1531','sưởng'=>'1532','sướng'=>'1533','sương'=>'1534','sưu'=>'1535','sửu'=>'1536','sứu'=>'1537','súy'=>'1538','suy'=>'1539','sủy'=>'1540','suyễn'=>'1541','ta'=>'1542','tá'=>'1543','tả'=>'1544','tà'=>'1545','tạ'=>'1546','tác'=>'1547','tắc'=>'1548','tạc'=>'1549','tặc'=>'1550','tái'=>'1551','tai'=>'1552','tại'=>'1553','tài'=>'1554','tải'=>'1555','tam'=>'1556','tẩm'=>'1557','tầm'=>'1558','tâm'=>'1559','tàm'=>'1560','tảm'=>'1561','tạm'=>'1562','tằm'=>'1563','tám'=>'1564','tản'=>'1565','tấn'=>'1566','tần'=>'1567','tán'=>'1568','tân'=>'1569','tàn'=>'1570','tẫn'=>'1571','tận'=>'1572','tăng'=>'1573','táng'=>'1574','tằng'=>'1575','tang'=>'1576','tạng'=>'1577','tàng'=>'1578','tặng'=>'1579','tảng'=>'1580','tắng'=>'1581','tánh'=>'1582','táo'=>'1583','tảo'=>'1584','tạo'=>'1585','tào'=>'1586','tao'=>'1587','táp'=>'1588','tập'=>'1589','tạp'=>'1590','tấp'=>'1591','tật'=>'1592','tất'=>'1593','tát'=>'1594','tạt'=>'1595','tấu'=>'1596','tẩu'=>'1597','tẩy'=>'1598','tây'=>'1599','tễ'=>'1600','tế'=>'1601','tể'=>'1602','tệ'=>'1603','tê'=>'1604','tề'=>'1605','thả'=>'1606','tha'=>'1607','thác'=>'1608','thắc'=>'1609','thạc'=>'1610','thạch'=>'1611','thai'=>'1612','thái'=>'1613','thải'=>'1614','tham'=>'1615','thẩm'=>'1616','thảm'=>'1617','thám'=>'1618','thâm'=>'1619','thậm'=>'1620','thầm'=>'1621','thấm'=>'1622','thân'=>'1623','thần'=>'1624','thán'=>'1625','thản'=>'1626','thận'=>'1627','thấn'=>'1628','than'=>'1629','thẩn'=>'1630','thảng'=>'1631','thắng'=>'1632','thăng'=>'1633','thang'=>'1634','thằng'=>'1635','thặng'=>'1636','thãng'=>'1637','thành'=>'1638','thanh'=>'1639','thánh'=>'1640','thạnh'=>'1641','thảo'=>'1642','tháo'=>'1643','thao'=>'1644','thập'=>'1645','tháp'=>'1646','thấp'=>'1647','thạp'=>'1648','thất'=>'1649','thật'=>'1650','thát'=>'1651','thâu'=>'1652','thấu'=>'1653','thẩu'=>'1654','thế'=>'1655','thê'=>'1656','thể'=>'1657','thệ'=>'1658','thị'=>'1659','thi'=>'1660','thỉ'=>'1661','thí'=>'1662','thì'=>'1663','thích'=>'1664','thiêm'=>'1665','thiểm'=>'1666','thiệm'=>'1667','thiềm'=>'1668','thiễm'=>'1669','thiên'=>'1670','thiện'=>'1671','thiển'=>'1672','thiền'=>'1673','thiến'=>'1674','thiếp'=>'1675','thiệp'=>'1676','thiết'=>'1677','thiệt'=>'1678','thiếu'=>'1679','thiểu'=>'1680','thiêu'=>'1681','thiệu'=>'1682','thiều'=>'1683','thìn'=>'1684','thình'=>'1685','thịnh'=>'1686','thính'=>'1687','thỉnh'=>'1688','thinh'=>'1689','thố'=>'1690','thọ'=>'1691','thổ'=>'1692','thô'=>'1693','thỏ'=>'1694','thóa'=>'1695','thoa'=>'1696','thỏa'=>'1697','thoái'=>'1698','thoại'=>'1699','thoan'=>'1700','thoán'=>'1701','thoản'=>'1702','thoát'=>'1703','thốc'=>'1704','thôi'=>'1705','thời'=>'1706','thối'=>'1707','thôn'=>'1708','thốn'=>'1709','thộn'=>'1710','thông'=>'1711','thống'=>'1712','thốt'=>'1713','thứ'=>'1714','thủ'=>'1715','thụ'=>'1716','thú'=>'1717','thu'=>'1718','thử'=>'1719','thư'=>'1720','thù'=>'1721','thự'=>'1722','thừ'=>'1723','thữ'=>'1724','thừa'=>'1725','thuẫn'=>'1726','thuần'=>'1727','thuấn'=>'1728','thuân'=>'1729','thuận'=>'1730','thuật'=>'1731','thúc'=>'1732','thực'=>'1733','thục'=>'1734','thức'=>'1735','thuế'=>'1736','thũng'=>'1737','thung'=>'1738','thứng'=>'1739','thuộc'=>'1740','thước'=>'1741','thược'=>'1742','thượng'=>'1743','thương'=>'1744','thường'=>'1745','thưởng'=>'1746','thướng'=>'1747','thưu'=>'1748','thứu'=>'1749','thùy'=>'1750','thủy'=>'1751','thụy'=>'1752','thúy'=>'1753','thuyên'=>'1754','thuyền'=>'1755','thuyết'=>'1756','tỉ'=>'1757','tí'=>'1758','tì'=>'1759','tị'=>'1760','ti'=>'1761','tích'=>'1762','tịch'=>'1763','tiệm'=>'1764','tiêm'=>'1765','tiềm'=>'1766','tiếm'=>'1767','tiên'=>'1768','tiện'=>'1769','tiền'=>'1770','tiển'=>'1771','tiễn'=>'1772','tiến'=>'1773','tiệp'=>'1774','tiếp'=>'1775','tiết'=>'1776','tiệt'=>'1777','tiêu'=>'1778','tiểu'=>'1779','tiều'=>'1780','tiếu'=>'1781','tiễu'=>'1782','tín'=>'1783','tịnh'=>'1784','tỉnh'=>'1785','tinh'=>'1786','tình'=>'1787','tĩnh'=>'1788','tính'=>'1789','tố'=>'1790','tổ'=>'1791','tộ'=>'1792','tô'=>'1793','tồ'=>'1794','tỏa'=>'1795','tọa'=>'1796','tòa'=>'1797','toa'=>'1798','toái'=>'1799','toại'=>'1800','toàn'=>'1801','toán'=>'1802','toan'=>'1803','toản'=>'1804','toánh'=>'1805','toát'=>'1806','tộc'=>'1807','tốc'=>'1808','tồi'=>'1809','tối'=>'1810','tội'=>'1811','tổn'=>'1812','tồn'=>'1813','tôn'=>'1814','tốn'=>'1815','tỗn'=>'1816','tống'=>'1817','tông'=>'1818','tổng'=>'1819','tòng'=>'1820','tốt'=>'1821','tra'=>'1822','trá'=>'1823','trà'=>'1824','trả'=>'1825','trạ'=>'1826','trắc'=>'1827','trác'=>'1828','trạc'=>'1829','trạch'=>'1830','trách'=>'1831','trái'=>'1832','trai'=>'1833','trại'=>'1834','trãi'=>'1835','trảm'=>'1836','trầm'=>'1837','trạm'=>'1838','trẫm'=>'1839','trấm'=>'1840','trám'=>'1841','trậm'=>'1842','trâm'=>'1843','trần'=>'1844','trân'=>'1845','trản'=>'1846','trăn'=>'1847','trấn'=>'1848','trận'=>'1849','tràn'=>'1850','trán'=>'1851','tràng'=>'1852','tráng'=>'1853','trang'=>'1854','trạng'=>'1855','tranh'=>'1856','tránh'=>'1857','trành'=>'1858','trạo'=>'1859','trảo'=>'1860','tráo'=>'1861','trào'=>'1862','trao'=>'1863','trấp'=>'1864','tráp'=>'1865','trập'=>'1866','trật'=>'1867','trất'=>'1868','trát'=>'1869','trâu'=>'1870','trệ'=>'1871','trị'=>'1872','trì'=>'1873','trí'=>'1874','tri'=>'1875','trĩ'=>'1876','Trí'=>'1877','trỉ'=>'1878','trích'=>'1879','trịch'=>'1880','triêm'=>'1881','triển'=>'1882','triền'=>'1883','triện'=>'1884','triên'=>'1885','triếp'=>'1886','triệp'=>'1887','triết'=>'1888','triệt'=>'1889','triệu'=>'1890','triêu'=>'1891','triều'=>'1892','trinh'=>'1893','trịnh'=>'1894','trình'=>'1895','trợ'=>'1896','trớ'=>'1897','trở'=>'1898','tróc'=>'1899','trọc'=>'1900','trọng'=>'1901','trú'=>'1902','trụ'=>'1903','trù'=>'1904','trữ'=>'1905','trư'=>'1906','trứ'=>'1907','tru'=>'1908','trừ'=>'1909','trử'=>'1910','trưa'=>'1911','truân'=>'1912','truất'=>'1913','truật'=>'1914','trực'=>'1915','trúc'=>'1916','trục'=>'1917','trúng'=>'1918','trung'=>'1919','trủng'=>'1920','trưng'=>'1921','trừng'=>'1922','trùng'=>'1923','trũng'=>'1924','trược'=>'1925','trước'=>'1926','trượng'=>'1927','trướng'=>'1928','trương'=>'1929','trường'=>'1930','trưởng'=>'1931','trừu'=>'1932','trứu'=>'1933','trửu'=>'1934','trữu'=>'1935','trưu'=>'1936','trụy'=>'1937','trùy'=>'1938','truy'=>'1939','trúy'=>'1940','truyền'=>'1941','truyện'=>'1942','truyên'=>'1943','truyến'=>'1944','tứ'=>'1945','tự'=>'1946','tu'=>'1947','tử'=>'1948','tư'=>'1949','tù'=>'1950','tú'=>'1951','từ'=>'1952','tụ'=>'1953','tữ'=>'1954','tuấn'=>'1955','tuần'=>'1956','tuân'=>'1957','tuẫn'=>'1958','tuẩn'=>'1959','tuất'=>'1960','tục'=>'1961','tức'=>'1962','túc'=>'1963','tuệ'=>'1964','tuế'=>'1965','tụi'=>'1966','tùng'=>'1967','tủng'=>'1968','túng'=>'1969','tụng'=>'1970','tung'=>'1971','tước'=>'1972','tượng'=>'1973','tường'=>'1974','tương'=>'1975','tướng'=>'1976','tưởng'=>'1977','tựu'=>'1978','tửu'=>'1979','tưu'=>'1980','tụy'=>'1981','túy'=>'1982','tủy'=>'1983','tùy'=>'1984','tuy'=>'1985','tuyên'=>'1986','tuyến'=>'1987','tuyền'=>'1988','tuyển'=>'1989','tuyệt'=>'1990','tuyết'=>'1991','tuynh'=>'1992','ty'=>'1993','tỷ'=>'1994','tỳ'=>'1995','tý'=>'1996','ủ'=>'1997','u'=>'1998','ư'=>'1999','ứ'=>'2000','uẩn'=>'2001','uấn'=>'2002','uân'=>'2003','uất'=>'2004','ức'=>'2005','úc'=>'2006','uế'=>'2007','úm'=>'2008','ủng'=>'2009','ưng'=>'2010','ứng'=>'2011','úng'=>'2012','ung'=>'2013','ước'=>'2014','ương'=>'2015','uông'=>'2016','uổng'=>'2017','ưởng'=>'2018','ưu'=>'2019','ửu'=>'2020','ủy'=>'2021','uy'=>'2022','úy'=>'2023','uyển'=>'2024','uyên'=>'2025','uyết'=>'2026','uynh'=>'2027','vân'=>'2028','vấn'=>'2029','vãn'=>'2030','văn'=>'2031','vẫn'=>'2032','vạn'=>'2033','vận'=>'2034','vặn'=>'2035','vãng'=>'2036','vanh'=>'2037','vật'=>'2038','vạt'=>'2039','vệ'=>'2040','vị'=>'2041','vi'=>'2042','vĩ'=>'2043','vì'=>'2044','ví'=>'2045','vỉ'=>'2046','viêm'=>'2047','viên'=>'2048','viện'=>'2049','viễn'=>'2050','viết'=>'2051','việt'=>'2052','vinh'=>'2053','vĩnh'=>'2054','vịnh'=>'2055','võ'=>'2056','vô'=>'2057','vong'=>'2058','vọng'=>'2059','võng'=>'2060','vu'=>'2061','vụ'=>'2062','vũ'=>'2063','vú'=>'2064','vực'=>'2065','vựng'=>'2066','vừng'=>'2067','vương'=>'2068','vượng'=>'2069','vưu'=>'2070','xa'=>'2071','xạ'=>'2072','xả'=>'2073','xã'=>'2074','xá'=>'2075','xà'=>'2076','xác'=>'2077','xải'=>'2078','xái'=>'2079','xâm'=>'2080','xam'=>'2081','xan'=>'2082','xán'=>'2083','xanh'=>'2084','xảo'=>'2085','xao'=>'2086','xế'=>'2087','xí'=>'2088','xỉ'=>'2089','xi'=>'2090','xích'=>'2091','xiêm'=>'2092','xiểm'=>'2093','xiển'=>'2094','xiễn'=>'2095','xiên'=>'2096','xiềng'=>'2097','xiệp'=>'2098','xiết'=>'2099','xiểu'=>'2100','xoa'=>'2101','xóa'=>'2102','xọa'=>'2103','xoang'=>'2104','xoát'=>'2105','xu'=>'2106','xử'=>'2107','xư'=>'2108','xú'=>'2109','xứ'=>'2110','xuân'=>'2111','xuẩn'=>'2112','xuất'=>'2113','xúc'=>'2114','xuế'=>'2115','xứng'=>'2116','xưng'=>'2117','xung'=>'2118','xước'=>'2119','xướng'=>'2120','xương'=>'2121','xưởng'=>'2122','xuy'=>'2123','xúy'=>'2124','xuyến'=>'2125','xuyên'=>'2126','xuyễn'=>'2127','xuyết'=>'2128','y'=>'2129','ỷ'=>'2130','ý'=>'2131','yếm'=>'2132','yểm'=>'2133','yêm'=>'2134','yển'=>'2135','yến'=>'2136','yên'=>'2137','yếp'=>'2138','yết'=>'2139','yểu'=>'2140','yêu'=>'2141','yếu'=>'2142');
	return $a;
}
function arraySanskrit()
{
	$a = array(
		'abhimaṁru'=>'a bi mâm ru',
		'acilillanā'=>'a chi li la na',
		//'akṣobhya'=>'ác sô bi a',
		'āmalakī'=>'a ma la ki',
		'bhikṣu'=>'bíc su',
		'bhikṣuṇī'=>'bíc su ni',
		'bodhyaṅgapuṣpakara'=>'bô đi ân ga bu sờ ba ca ra',
		'cāka'=>'cha ca',
		'candrabhāgā'=>'chanh đờ ra ba ga',
		'cundī'=>'chun đi',
		'dhāyini'=>'đa di ni',
		'elāpattra'=>'ê la bách tra',
		'erāvatī'=>'ê ra va ti',
		'gopaka'=>'gô ba ca',
		'harītakī'=>'ha ri ta ki',
		'himaratī'=>'hi ma ra ti',
		'hullura'=>'hu lu ra',
		'jambū'=>'cham bu',//trái mận, rose-apple, Jambū
		'kalaśodarī'=>'ca la sô đa ri',
		//'kamkara'=>'cam ca ra',
		//'kamkara'=>'cam ca ra',
		'kapila'=>'ca bi la',
		'kauśika'=>'câu si ca',
		'kāśīka'=>'ca si ca',
		'kāyale'=>'ca da lê',
		'kelava'=>'ke la va',
		'kṛkāla'=>'cờ ri ca la',
		'krośa'=>'cờ rô sa',
		'kubera'=>'cu bê ra',
		'kundapadhaṇiyaka'=>'cun đa ba đa ni da ca',
		'maṇi'=>'ma ni',
		'maṇḍala'=>'man đa la',
		'mātaṅga'=>'ma tân ga',
		'mithilā'=>'mi thi la',
		'nayuta'=>'na du ta',
		'oṃ'=>'ôm',
		'pala'=>'ba la',
		'pāṇḍuka'=>'ban đu ca',
		'piṅgala'=>'bin ga la',
		'raṇi'=>'ra ni',
		'ratikarahasanam'=>'ra ti ca ra ha sa nâm',
		'śankara'=>'san ca ra',
		'śaṅkha'=>'sân kha',
		'śatadruḥ'=>'sa ta đờ ru hu',
		'sāvitrī'=>'sa vi tri',
		'sumāgandhā'=>'su ma ganh đa',
		'suraṣṭa'=>'su ra sờ ta',
		'tāmra'=>'tam ra',
		'timiṃgira'=>'ti mim gi ra',
		'upalāla'=>'u ba la la',
		'vardhana'=>'va đa na',
		'vāsava'=>'va sa va',
		'vibhītakī'=>'vi bi ta ki',
		//'vimbara'=>'vim ba ra',
		'virādha'=>'vi ra đa',
		'yamunā'=>'da mu na',
	);
	return $a;
}
function arrayBacNam1()
{
	$a = array(	'生sanh' => '生sinh',
				'生Sanh' => '生Sinh',
				'正chánh' => '正chính',
				'正Chánh' => '正Chính',
				'政chánh' => '政chính',
				'政Chánh' => '政Chính',
				'性tánh' => '性tính',
				'性Tánh' => '性Tính',
				'福phước' => '福phúc',
				'福Phước' => '福Phúc',
				'頂đảnh' => '頂đỉnh',
				'頂Đảnh' => '頂Đỉnh',
				'領lãnh' => '領lĩnh',
				'領Lãnh' => '領Lĩnh',
				'豆đậu' => '豆đỗ',
				'豆Đậu' => '豆Đỗ');
				
	return $a;
}
function arrayBacNam2()
{
	$a = array(	'sinh' => 'sanh',
				'chính' => 'chánh',
				'tính' => 'tánh',
				'phúc' => 'phước',
				'đỉnh' => 'đảnh',
				'lĩnh' => 'lãnh',
				'đỗ' => 'đậu');
	return $a;
}
function arrayBac2Nam()
{
	$a = array(	
		'chính' => 'chánh',
		'Chính' => 'Chánh',
		
		'sinh' => 'sanh',
		'Sinh' => 'Sanh',
		
		'phúc' => 'phước',
		'Phúc' => 'Phước',
		
		'tính' => 'tánh',
		'Tính' => 'Tánh',
		
		'đỉnh' => 'đảnh',
		'Đỉnh' => 'Đảnh',
		
		'lĩnh' => 'lãnh',
		'Lĩnh' => 'Lãnh',
		
		'đỗ' => 'đậu',
		'Đỗ' => 'Đậu',
		
		
		
		'nghìn' => 'ngàn',
		'Nghìn' => 'Ngàn',
		
		'nhăm' => 'lăm',
		'Nhăm' => 'Lăm',
		
		'hổ' => 'cọp',
		'Hổ' => 'Cọp',
		
		'báo' => 'beo',
		'Báo' => 'Beo',
		
		'muộn' => 'trễ',
		'Muộn' => 'Trễ',
		
		'bát' => 'chén',
		'Bát' => 'Chén',
		
		'chăn' => 'mền',
		'Chăn' => 'Mền',
		
		'béo' => 'mập',
		'Béo' => 'Mập',

		'nhanh' => 'mau',
		'Nhanh' => 'Mau',

		'thuê' => 'mướn',
		'Thuê' => 'Mướn',
		
		'nhặt' => 'lượm',
		'Nhặt' => 'Lượm',

		'ngã' => 'té',
		'Ngã' => 'Té',
		
		'vừng' => 'mè',
		'Vừng' => 'Mè',
		
		'dẫu cho' => 'cho dù',
		'Dẫu cho' => 'Cho dù',
		'Dẫu Cho' => 'Cho Dù',
		
		'mặc dầu' => 'mặc dù',
		'Mặc dầu' => 'Mặc dù',
		'Mặc Dầu' => 'Mặc Dù',
		
		'thìa' => 'muỗng',
		'Thìa' => 'Muỗng',
		
		'đĩa' => 'dĩa',//
		'Đĩa' => 'Dĩa',//
		
		'vẹt' => 'két',//
		'Vẹt' => 'Két',//
		
		'buồn nôn' => 'bị ói',
		'Buồn nôn' => 'Bị ói',
		'Buồn Nôn' => 'Bị Ói',
		
		'quả tim' => 'trái tim',
		'Quả tim' => 'Trái tim',
		'Quả Tim' => 'Trái Tim',
		
		'áo ấm' => 'áo lạnh',
		'Áo ấm' => 'Áo lạnh',
		'Áo Ấm' => 'Áo Lạnh',
		
		'vồ lấy' => 'chụp lấy',
		'Vồ lấy' => 'Chụp lấy',
		'Vồ Lấy' => 'Chụp Lấy',
		
		'khuân vác' => 'khiêng vác',
		'Khuân vác' => 'Khiêng vác',
		'Khuân Vác' => 'Khiêng Vác',
		
		'chung quanh' => 'xung quanh',
		'Chung quanh' => 'Xung quanh',
		'Chung Quanh' => 'Xung Quanh',
		
		'buồn cười' => 'mắc cười',//
		'Buồn cười' => 'Mắc cười',//
		'Buồn Cười' => 'Mắc Cười',//
		
		'nhà cao tầng' => 'nhà lầu',//
		'Nhà cao tầng' => 'Nhà lầu',//
		'Nhà Cao Tầng' => 'Nhà Lầu',//
		
		'bí ngô' => 'bí đao',//
		'Bí ngô' => 'Bí đao',//
		'Bí Ngô' => 'Bí Đao',//
		
		'bí đỏ' => 'bí rợ',//
		'Bí đỏ' => 'Bí rợ',//
		'Bí Đỏ' => 'Bí Rợ',//
		
		'quả na' => 'mãng cầu',//
		'Quả na' => 'Mãng cầu',//
		'Quả Na' => 'Mãng Cầu',//
		
		'chuột rút' => 'vọp bẻ',//
		'Chuột rút' => 'Vọp bẻ',//
		'Chuột Rút' => 'Vọp Bẻ',//
		
		'thi trượt' => 'thi rớt',//
		'Thi trượt' => 'Thi rớt',//
		'Thi Trượt' => 'Thi Rớt',//
		
		'ngày kia' => 'ngày mốt',//
		'Ngày kia' => 'Ngày mốt',//
		'Ngày Kia' => 'Ngày Mốt',//
		
		'anh cả' => 'anh hai',//
		'Anh cả' => 'Anh hai',//
		'Anh Cả' => 'Anh Hai',//
		
		'anh hai' => 'anh ba',//
		'Anh hai' => 'Anh ba',//
		'Anh Hai' => 'Anh Ba',//
		
		'chị cả' => 'chị hai',//
		'Chị cả' => 'Chị hai',//
		'Chị Cả' => 'Chị Hai',//
		
		'chị hai' => 'chị ba',//
		'Chị hai' => 'Chị ba',//
		'Chị Hai' => 'Chị Ba',//

		'đánh rắm' => 'xì hơi',//
		'Đánh rắm' => 'Xì hơi',//
		'Đánh Rắm' => 'Xì Hơi',//
		
		'cốc vại' => 'ly cối',//
		'Cốc vại' => 'Ly cối',//
		'Cốc Vại' => 'Ly Cối',//
		
		'đậu phụ' => 'đậu hũ',//
		'Đậu phụ' => 'Đậu hũ',//
		'Đậu Phụ' => 'Đậu Hũ',//
		
		'lạc' => 'đậu phộng',//
		'Lạc' => 'Đậu phộng',//
		'Lạc' => 'Đậu Phộng',//
		
		'đỗ tương' => 'đậu nành',//
		'Đỗ tương' => 'Đậu nành',//
		'Đỗ Tương' => 'Đậu Nành',//
		
		'củ đậu' => 'củ sắn',//
		'Củ đậu' => 'Củ sắn',//
		'Củ Đậu' => 'Củ Sắn',//
		
		'bánh nếp' => 'bánh ít',//
		'Bánh nếp' => 'Bánh ít',//
		'Bánh Nếp' => 'Bánh Ít',//
		
		'đậu khế' => 'đậu rồng',//
		'Đậu khế' => 'Đậu rồng',//
		'Đậu Khế' => 'Đậu Rồng',//
		
		'quả bóng' => 'trái banh',//
		'Quả bóng' => 'Trái banh',//
		'Quả Bóng' => 'Trái Banh',//
		
		'quả roi' => 'trái mận',//rose-apple, Jambū
		'Quả roi' => 'Trái mận',//
		'Quả Roi' => 'Trái Mận',//
		
		//-------------------manual search
		
		'dẫu' => 'dù',
		'Dẫu' => 'Dù',
		
		'lợn' => 'heo',
		'Lợn' => 'Heo',
		
		'giầy' => 'giày',
		'Giầy' => 'Giày',
		
		'phết' => 'phẩy',
		'Phết' => 'Phẩy',
		
		'linh' => 'lẻ',//
		'Linh' => 'Lẻ',//
		
		'mũ' => 'nón',
		'Mũ' => 'Nón',
		
		'rán' => 'chiên',
		'Rán' => 'Chiên',
		
		'cân' => 'ký',
		'Cân' => 'Ký',
		
		'đắt' => 'mắc',
		'Đắt' => 'mắc',
		
		'gầy' => 'ốm',
		'Gầy' => 'Ốm',
		
		'ốm' => 'bệnh',
		'Ốm' => 'Bệnh',
		
		'quả' => 'trái',
		'Quả' => 'Trái',
		
		'mắng' => 'chửi',
		'Mắng' => 'Chửi',
		
		'bố' => 'cha',
		'Bố' => 'Cha',
		
		'ô' => 'dù',//
		'Ô' => 'Dù',//
		
		'lọ' => 'chai',//
		'Lọ' => 'Chai',//
		
		'cốc' => 'ly',//
		'Cốc' => 'Ly',//
		
		'hỏng' => 'hư',//
		'Hỏng' => 'Hư',//
		
		'ngô' => 'bắp',//
		'Ngô' => 'Bắp',//
		
		'dứa' => 'thơm',//
		'Dứa' => 'Thơm',//
		
		'gáy' => 'ót',//
		'Gáy' => 'Ót',//
		
		'bâu' => 'bu',//
		'Bâu' => 'Bu',//
		
		'mang' => 'đem',//
		'Mang' => 'Đem',//
		
		'xem' => 'coi',//
		'Xem' => 'Coi',//		
	);
	return $a;
}
function arrayBacNamInsert()
{
	$a = arrayBac2Nam();
	$b = array();
	foreach ($a as $key => $value)
	{
		if($key == 'dẫu') break;
		else
		{
			$b[$value] = $key;
		}
	}
	return $b;
}








//admin------------------------------
global $pdoa;
if(offline())
{
	//$pdoa = new PDO('sqlite:a/db/phienam.db');
	$pdoa = new PDO('mysql:host=localhost;port=3306;dbname=daitangkinh', 'root', '');
	if(!isset($_SESSION['Translator'])) $_SESSION['Translator']= 'Punctuation';
}
function islocal() { return is_translator() && stristr($_GET['f'], "@InProgress/");}
function is_translator() { return isset($_SESSION['Translator']); }
function pdo_row_exist($sql)
{
	$rval = false;
	global $pdo;
	$stmt = $pdo->query($sql);
	$row = $stmt->fetch(PDO::FETCH_ASSOC);
	if($row) $rval = true;
	return $rval;
}
function pdoa_row_exist($sql)
{
	$rval = false;
	global $pdoa;
	$stmt = $pdoa->query($sql);
	$row = $stmt->fetch(PDO::FETCH_ASSOC);
	if($row) $rval = true;
	return $rval;
}
function searchInAllSutras($type, $phrase)
{
	$Starting = 0;
	if(isset($_SESSION['phrase']) && $phrase == $_SESSION['phrase'])
	{
		$_SESSION[$phrase] += 100;
		$Starting = $_SESSION[$phrase];
	}
	else
	{
		$_SESSION['phrase'] = $phrase;
		$_SESSION[$phrase] = 0;
	}
	$sql = "SELECT HanViet, Viet FROM han_split WHERE ";
	if($type == 'hanviet')
		$sql .= "HanViet like '%$phrase%' AND Viet NOT LIKE '%♪ %'";
	else if($type == 'tiengviet')
		$sql .= "Viet like '%$phrase%'";
	else if($type == 'hanwords')
		$sql = "SELECT FullString FROM han_words WHERE FullString like '%$phrase%'";
	$sql .=" ORDER BY Counter DESC, Word ASC LIMIT $Starting,100";
	
	$i = 0;
	global $pdoa;
	$query = $sql;
	$stmt = $pdoa->query($query);
	foreach($stmt as $row)
	{
		echo "<sub>" . ($_SESSION[$phrase] + ++$i) . "</sub> ";
		if($type == 'hanwords')
		{
			echo $row['FullString'] . '<hr>';
		}
		else
		{
			$hanviet = $row['HanViet'];
			$viet = str_replace('\r\n', '<br>', $row['Viet']); 
			if($type == 'hanviet')
				$hanviet = preg_replace("/($phrase)/i", "<b>$1</b>", $hanviet);
			else if($type == 'tiengviet')
				$viet = preg_replace("/($phrase)/i", "<b>$1</b>", $viet);
			
			echo '<span style="color:#535353;">' . $hanviet . '</span><br>' . nl2br(stripslashes($viet)) . '<hr>';
		}
	}
	if($i == 0) $_SESSION['phrase'] = NULL;
}
function folder($f)
{
	$file = '';
	$a = explode('/', $f);
	$TitleID = $a[0];
	global $pdo;
	$query = "SELECT FileID FROM tripitaka_title WHERE TitleID='$TitleID' AND Stage='Viet' LIMIT 1";
	$stmt = $pdo->query($query);
	$row = $stmt->fetch(PDO::FETCH_ASSOC);
	if($row) $f = $row['FileID'] . (count($a) == 2 ? '/' . $a[1] : '');
	
	$translators = translators();
	for($i = 0; $i < count($translators); $i++)
	{
		$a = $translators[$i];
		$tmp = 'Text/' . $a['id'] . '/' . $f . '.txt'; 
		if(file_exists($tmp))
		{
			$file = $tmp;
			break;
		}
	}
	if($file == '')
	{
		for($i = 0; $i < count($translators); $i++)
		{
			$a = $translators[$i];
			$tmp = 'Text/' . $a['id'] . '/@InProgress/' . $f . '.txt';
			if(file_exists($tmp))
			{
				$file = $tmp;
				break;
			}
		}
	}
	return $file;
}
function translators()
{
	$a = array(	array('id'=>'Punctuation', 'name'=>'Kinh Đang Chấm Câu'),
				array('id'=>'NguyenThuan', 'name'=>'Nguyên Thuận'));
	return $a;
}
?>